d("cartOrderReviewView",['util','datepicker'], function(util ,datepicker) {

    return {
        extendCartOrderReviewView: function(orderReviewView) {
            bindPaymentMethod();
            //Initiliaze Controller Method
            var javascriptLibrary = 'orderReview';//API JS
            var apexClassName= 'TKAMB2B_CheckoutController';
            var apexMethods = ['retrieveAddressData','retrieveCheckoutConfigInfo'];
            //Initializing JS Remoting Library from Apex Class
            util.initializeVisualforceRemoting(javascriptLibrary , apexClassName ,  apexMethods);

            let reqData ={};
            //reqData.cartId  = CCRZ.currentCart.attributes.sfid;
            if(CCRZ.cartCheckoutModel.attributes.account){
                reqData.accountid  = CCRZ.cartCheckoutModel.attributes.effectiveAccountID;
            }
 
            CCRZ.subsc.orderReview.retrieveCheckoutConfigInfo(JSON.stringify(reqData) , populateCheckoutData); 
            //populateShippingMethods();

            $( "#SubmitOrder" ).on('click',function() {
                initCheckOut();
            });

            $( "#updateShippingAddressValues" ).on('click',function() {
                updateShippingAddressValues();
            });
            
            $( "#termsConditionsCheckbox" ).on('click',function() {
                $('#termsWarning').hide();
            });  
        },
    }

    function populateCheckoutData(resp ,event)
    {
        let shippingMethodOptionArray = [];
        if(resp && resp.data )
        {
            /*if(resp.data.useraccount){
                if(resp.data.useraccount.Shipping_Terms__c){
                    $('#freightTerms_section').show();
                    document.getElementById('freightTerms').innerText = resp.data.useraccount.Shipping_Terms__c;
                }
                if(resp.data.useraccount.TK_INCO_Terms__c){
                    $('#icoterms_section').show();
                    document.getElementById('icoterms').innerText = resp.data.useraccount.TK_INCO_Terms__c;    
                }                
                 
    
                let total = Number(CCRZ.cartCheckoutModel.attributes.totalAmount).toFixed(2);
                if(resp.data.useraccount.ShippingCountry == 'US'){
                    $('#discountShippingMessage').show();
                    if(total >= 4000){
                        document.getElementById("discountShippingMessage").innerHTML = CCRZ.pagevars.pageLabels['TKB2B_Free_Ground_Freight_Qualified'];
                    }else{
                        let message = CCRZ.pagevars.pageLabels['TKB2B_Free_Ground_Freight_Unqualified'];
                        let qualifiedAmount = parseFloat(CCRZ.pagevars.pageLabels['TKB2B_Free_Shipping_Amount']-total).toFixed(2);
                        message = message.replace('TKB2B_Free_Shipping_Amount', qualifiedAmount);
                        document.getElementById("discountShippingMessage").innerHTML = message;
                    }
                }
            }else{
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'ERROR',
                            message : 'Error in retrieving account data',
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });                
            }

            if(!resp.data.shippingmethod){
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'ERROR',
                            message : 'Error in retrieving shipping methods.',
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
            }*/

            if(resp.data.warehouse){

                let uniqueWarehouseValues = [];
                let selectList = document.getElementById('COshippingmethod');
                /*let newOption = document.createElement("option");
                newOption.text = 'Please select a warehouse location'; 
                newOption.value = '';
                newOption.selected = true;
                selectList.appendChild(newOption);*/
                for (let i = 0; i < resp.data.warehouse.length; i++) {
                    let newOption = document.createElement("option");

                    if(i == 0){
                        newOption.selected = true;
                    }

                    newOption.text = resp.data.warehouse[i].Shipping_Method__c; 
                    newOption.value = resp.data.warehouse[i].Shipping_Method__c;
                    selectList.appendChild(newOption);
                }            

                /*
                let warehouseElement = document.getElementById('COwarehouse');

                warehouseElement.addEventListener("change", function () {
                    let warehousevalue = $('#COwarehouse').val();
                    let shippingMethodElement = document.getElementById('COshippingmethod');
                    shippingMethodElement.length = 0;
                    if(warehousevalue){
                        for(let i = 0; i < shippingMethodOptionArray.length; i++){
                            if(shippingMethodOptionArray[i][0] === warehousevalue){
                                for(let j = 0; j < shippingMethodOptionArray[i][1].length; j++){
                                    shippingMethodElement.appendChild(shippingMethodOptionArray[i][1][j]);
                                }
                            }
                        }
                    }else{
                        let selectList = document.getElementById('COshippingmethod');
                        selectList.length = 0;
                        let newOption = document.createElement("option");
                        newOption.text = 'Please select a warehouse first'; 
                        newOption.value = '';
                        newOption.selected = true;
                        selectList.appendChild(newOption);
                    }

                });*/
            } else{
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'ERROR',
                            message : CCRZ.pagevars.pageLabels.TKAMB2B_Checkout_ErrorShipings,
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });                 
            }

            /*if(resp.data.shippingmethod){
                if (document.getElementById('COshippingmethod')) {
                    let selectList = document.getElementById('COshippingmethod');
                    let newOption = document.createElement("option");
                    newOption.text = resp.data.shippingmethod[0].MasterLabel; //+' ('+Math.trunc(uoms[i].Factor)+')';
                    newOption.value = resp.data.shippingmethod[0].Oracle_Code__c;
                    newOption.selected = true;
                    selectList.appendChild(newOption);
                    for (let i = 1; i < resp.data.shippingmethod.length; i++) {
                        let newOption = document.createElement("option");
                        newOption.text = resp.data.shippingmethod[i].MasterLabel; //+' ('+Math.trunc(uoms[i].Factor)+')';
                        newOption.value = resp.data.shippingmethod[i].Oracle_Code__c;
                        selectList.appendChild(newOption);
                    }
                }
            } else{
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'ERROR',
                            message : 'Error in retrieving shipping methods.',
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });                 
            }*/

            

           
        }
    }

    function initCheckOut(){
        let poInputVal = $('#COPurchaseOrderNumber').val();

        //validation for po 

        if(!document.getElementById("termsConditionsCheckbox").checked){
            $('#termsWarning').show();
            return;            
        }
        /*if(/\s/.test(poInputVal) || poInputVal.length>12){
            CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                        severity : 'WARN',
                        message : CCRZ.pagevars.pageLabels['VRTB2B_Po_Validation'],
                        classToAppend : 'messagingSection-Warning'
                    }
                ]
            });
            return;                  
        }*/

       /* if(poInputVal==null || poInputVal===''){
            CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                        severity : 'WARN',
                        message : CCRZ.pagevars.pageLabels['TKMB2B_Po_Warning'],
                        classToAppend : 'messagingSection-Warning'
                    }
                ]
            });
            return;
            
        }*/
        //update cart 

        //let criticalOrder = document.getElementById("COcriticaltrue").checked;
        let comment =  $('#COcomments').val();
        let shippingmethod = $('#COshippingmethod').val();
        let shippingmethodname = $('#COshippingmethod  option:selected').text();

        let reqData ={};
        if(CCRZ.currentCart.attributes.sfid){
            reqData.cartId = CCRZ.currentCart.attributes.sfid;
        }else{
            reqData.cartId = CCRZ.pagevars.currentCartID;
        }
        reqData.comment  = comment;
        reqData.purchase_order_no  = poInputVal;
        reqData.shippingmethod = shippingmethod;
        reqData.shippingmethodname = shippingmethodname;


        //buyer info
        reqData.buyerEmail = CCRZ.cartCheckoutModel.attributes.buyerEmail;
        reqData.buyerFirstName = CCRZ.cartCheckoutModel.attributes.buyerFirstName;
        reqData.buyerLastName = CCRZ.cartCheckoutModel.attributes.buyerLastName;
        reqData.buyerPhone = CCRZ.cartCheckoutModel.attributes.buyerPhone;

        reqData["billingAddress"] = CCRZ.cartCheckoutModel.attributes.billingAddress;
        reqData["shippingAddress"] = CCRZ.cartCheckoutModel.attributes.shippingAddress;

        reqData["billingAddress"].addressList = {};
        reqData["billingAddress"].countryList = {};

        reqData["shippingAddress"].addressList = {};
        reqData["shippingAddress"].countryList = {};


        var javascriptLibrary = 'orderReview';//API JS
        var apexClassName= 'TKAMB2B_CheckoutController';
        var apexMethods = ['populateShippingDetails'];
        //Initializing JS Remoting Library from Apex Class
        util.initializeVisualforceRemoting(javascriptLibrary , apexClassName ,  apexMethods);

        CCRZ.subsc.orderReview.populateShippingDetails(JSON.stringify(reqData), function(resp,event){
            if(resp && resp.success ){      
                CCRZ.pubSub.trigger("action:processPayment", {"accountNumber":poInputVal, "accountType":"po"});
            }else{
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'ERROR',
                            message : CCRZ.pagevars.pageLabels.TKAMB2B_Checkout_ErrorShipingsDetails,
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
            }
        });

    }

    function populateShippingMethods(){
        let shippingMethodRaw = CCRZ.pagevars.pageLabels.TKB2B_Shipping_Methods;
        let shippingMethod = shippingMethodRaw.split(';');

            if (document.getElementById('COshippingmethod') && shippingMethod.length > 0) {
                let selectList = document.getElementById('COshippingmethod');
                let newOption = document.createElement("option");
                newOption.text = shippingMethod[0]; //+' ('+Math.trunc(uoms[i].Factor)+')';
                newOption.value = shippingMethod[0];
                newOption.selected = true;
                selectList.appendChild(newOption);
                for (let i = 1; i < shippingMethod.length; i++) {
                    let newOption = document.createElement("option");
                    newOption.text = shippingMethod[i]; //+' ('+Math.trunc(uoms[i].Factor)+')';
                    newOption.value = shippingMethod[i];
                    selectList.appendChild(newOption);
                }
            }
    }


    function populateOrderReviewConfig(resp ,event){
        if(resp && resp.data)
        {
            var isPoRequired = resp.data.isPoRequired;
            var isCreditCardRequired = resp.data.isCreditCardRequired;
            var addCmtLimit = resp.data.addCommentLimit;
            let allowCreditCardCheckout = checkCreditCardAllowed(resp.data);
            if(allowCreditCardCheckout){
                if(isCreditCardRequired){
                    $('#vrtPayMethodId option[value="po"]').remove();
                    $('.hideCCBtn').show();
                    $('.showPoBtn').hide();
                }
            }else{
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                        severity : 'WARN',
                        message : CCRZ.pagevars.pageLabels['VRTB2B_PayrocDown'],
                        classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
                $('#vrtPayMethodId option[value="cc"]').remove();
                $('.hideCCBtn').hide();
            }
            
            $( "#vrtSubmitOrderPO" ).on('click',function() {
                initPOCheckOut(isPoRequired,isCreditCardRequired);
            });
            $( "#vrtSubmitOrderCC" ).on('click',function() {
                initCCCheckOut(isPoRequired,isCreditCardRequired);
            });  
            $("#addComments").attr('maxlength',addCmtLimit);
            
        }
    }
    function checkCreditCardAllowed(dataMap){
        var allowCreditCardCheckout = true;
        if(dataMap.hasOwnProperty('allowCreditCardCheckout')){
            allowCreditCardCheckout = dataMap.allowCreditCardCheckout;
        }
        if(CCRZ.cartCheckoutModel.attributes){
            if(CCRZ.cartCheckoutModel.attributes.totalAmount == 0){
                allowCreditCardCheckout = false;
            }
            let cItems = CCRZ.cartCheckoutModel.attributes.cartItems ;
            if(cItems && cItems!=null){
                $(cItems).each(function(index,ele){
                    if(ele.itemTotal==0){
                        allowCreditCardCheckout = false;
                        return;
                    }
                });
            }
        }
        return allowCreditCardCheckout;
    }

    //Response Call back method
    function populateDeliveryDate(resp ,event)
    {

        if(resp && resp.data && resp.data.deliveryDays)
        {
            let dates = resp.data.deliveryDays;
            if(!dates.includes(true)){
                dates = [true, true, true, true, true, false, false];
            }
            //beforeShowDayGenerator is a function that returns a function and stores it in beforeShowDayFunction variable
            const beforeShowDayFunction = function beforeShowDayGenerator(dates) {
                return function (date) {
                    //td 0 = sunday, 1 = monday etc
                    let td = date.getDay();
                    if (td === 0) {
                        td = 6;
                    } else {
                        td = td - 1;
                    }
                    return [dates[td], ''];
                }
            }(dates);

            $("#datepicker").datepicker({
                minDate: new Date(),
                beforeShowDay: beforeShowDayFunction
            });
            if(CCRZ.cartCheckoutModel.attributes.hasOwnProperty('requestedDate')){
                let reqdateValue = CCRZ.cartCheckoutModel.attributes['requestedDate'];
                if(typeof reqdateValue !='undefined' && reqdateValue!= null && reqdateValue!==''){
                    //getting local time versus GMT/UTC time difference in minutes
                    var timeDifference = new Date().getTimezoneOffset();
                    reqdateValue = reqdateValue + Math.abs(timeDifference)*60*1000;

                    let tempDate = new Date(reqdateValue);
                    var format = 'mm/dd/yy';

                    resp.data.deliveryDate = $.datepicker.formatDate(format, tempDate);
                }
            }else if(CCRZ.cartCheckoutModel.attributes.hasOwnProperty('requestedDateStr')){
                let reqdateValueStr = CCRZ.cartCheckoutModel.attributes['requestedDateStr'];
                if(reqdateValueStr!= null && reqdateValueStr!=''){
                    resp.data.deliveryDate = reqdateValueStr;
                }
                
            }

            if(resp.data.deliveryDate)
            {
                $('#datepicker').val(resp.data.deliveryDate);
            }
            
        }
    }

    function bindPaymentMethod()
    {
        $( "#vrtPayMethodId" ).change(function() {
            var selectedPayMethod = $( "#vrtPayMethodId option:selected" ).val();
            if(selectedPayMethod==='po'){
                $('.hideCCBtn').hide();
                $('.showPoBtn').show();
            }else if(selectedPayMethod==='cc'){
                $('.hideCCBtn').show();
                $('.showPoBtn').hide();
            }
        });
        $( "#addCommentId" ).on('click',function() {
            $('#addComments').toggle();
        });
    }

    function initPOCheckOut(isPoRequired){
        let poInputVal = $('#poNumber').val();

        if(/\s/.test(poInputVal) || poInputVal.length>12){
            CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                        severity : 'WARN',
                        message : CCRZ.pagevars.pageLabels['VRTB2B_Po_Validation'],
                        classToAppend : 'messagingSection-Warning'
                    }
                ]
            });
            return;                  
        }
        if(poInputVal==null || poInputVal===''){
            if(isPoRequired){
                //show alert
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'WARN',
                            message : CCRZ.pagevars.pageLabels['VRTB2B_Po_Warning'],
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
                return;
            }
        }
        populateShippingDetails('po',poInputVal);
        
    }
    
    function initCCCheckOut(isPoRequired){
        let poInputVal = $('#poNumber').val();

        if(poInputVal==null || poInputVal===''){
            if(isPoRequired){
                //show alert
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'WARN',
                            message : CCRZ.pagevars.pageLabels['VRTB2B_Po_Warning'],
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
                return;
            }
        }

        if(!(poInputVal==null || poInputVal==='')){
            if(/\s/.test(poInputVal) || poInputVal.length>12){
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'WARN',
                            message : CCRZ.pagevars.pageLabels['VRTB2B_Po_Validation'],
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
                return;                  
            }else{
                CCRZ.setCookieWithPath('apex__poNumber' , poInputVal  , 1 , '/');
            }
        }
        
        populateShippingDetails('cc', poInputVal);
    }
    
    function populateShippingDetails(payType,poVal){
        let shipdate  = $('#datepicker').val();
        let comment =  $('#addComments').val();
        let reqData ={};
        if(CCRZ.currentCart.attributes.sfid)
        {
            reqData.cartId = CCRZ.currentCart.attributes.sfid;
        }
        else
        {
            reqData.cartId = CCRZ.pagevars.currentCartID;
        }
        reqData.shipdate  = shipdate;
        reqData.comment  = comment;
        reqData.purchase_order_no  = poVal;

        var javascriptLibrary = 'orderReview';//API JS
        var apexClassName= 'VRTB2B_OrderReviewController';
        var apexMethods = ['retrieveDeliveryDate','isPOAllowed','populateShippingDetails'];
        //Initializing JS Remoting Library from Apex Class
        util.initializeVisualforceRemoting(javascriptLibrary , apexClassName ,  apexMethods);

        CCRZ.subsc.orderReview.populateShippingDetails(JSON.stringify(reqData) , function(resp,event){
            if(resp && resp.success ){
                CCRZ.cartCheckoutModel.attributes['note'] = comment;
                CCRZ.cartCheckoutModel.attributes['requestedDateStr'] = shipdate;
                if(shipdate!=''){
                    let newDate = new Date(shipdate);
                    if(newDate){
                        CCRZ.cartCheckoutModel.attributes['requestedDate'] = Date.parse(newDate);
                    }
                }
                
                if(payType==='po'){
                    handlePOCheckout(poVal);
                }else if(payType==='cc'){
                    handleCCCheckout();
                }
            }else{
                CCRZ.pubSub.trigger('pageMessage',{messages:[{type : 'CUSTOM',
                            severity : 'ERROR',
                            message : CCRZ.pagevars.pageLabels['VRTB2B_ShippingDetail_Error'],
                            classToAppend : 'messagingSection-Warning'
                        }
                    ]
                });
            }
        });
    }
    function handleCCCheckout(){
        CCRZ.cartCheckoutView.slideRight();
    }

    function handlePOCheckout(poVal){
        CCRZ.pubSub.trigger("action:processPayment", {"accountNumber":poVal, "accountType":"po"});
        //CCRZ.cartCheckoutView.slideRight();
    }

    function updateShippingAddressValues(){
        let shipping = document.getElementsByName("editShippingAddress");

        let shippingAddress = CCRZ.cartCheckoutModel.attributes.shippingAddress;

        for(var i=0;i < shipping.length;i++){

            if(shipping[i].lang){

                if(shipping[i].lang == 'firstName'){
                    shippingAddress.firstName = shipping[i].value;
                }
                else if(shipping[i].lang == 'lastName'){
                    shippingAddress.lastName = shipping[i].value;
                }
                else if(shipping[i].lang == 'address1'){
                    shippingAddress.address1 = shipping[i].value;
                }
                else if(shipping[i].lang == 'city'){
                    shippingAddress.city = shipping[i].value;
                }
                else if(shipping[i].lang == 'state'){
                    shippingAddress.state = shipping[i].value;
                }
                else if(shipping[i].lang == 'postalCode'){
                    shippingAddress.postalCode = shipping[i].value;
                }


            }

        }

        CCRZ.cartCheckoutModel.attributes.shippingAddress = shippingAddress;

        setVisibleAddressInfo(shippingAddress,1);

        $('#COShippingEditModal .close').click();

    }
});