d("quickOrderView",['util', "quickOrderModel"], function(UTIL, quickOrderModel) {

    return {       
        // Quick Order View for overall usage
        extendQuickOrderView: function() {
            
            //Extend a new quick order View
            const defaultSize = 5, sizeIncrement = 1;
            CCRZ.views.quickOrderCustomView = CCRZ.CloudCrazeView.extend({
                el: CCRZ.uiProperties.QuickOrderView.desktop.selector,
                viewName: "quickOrderView",
                templateDesktop : CCRZ.util.template(CCRZ.uiProperties.QuickOrderView.desktop.tmpl),
                templatePhone : CCRZ.util.template(CCRZ.uiProperties.QuickOrderView.desktop.tmpl),
                init: function(){
                    let v = this;
                    v.model.set('products', v.addDefaultValues(defaultSize));
                    v.model.set('disableAddToCartBtn', true);
                    v.model.set('arrayData', []);
                    v.render();
                },
                renderDesktop : function(){
                    $(this.el).html(this.templateDesktop(this.model.toJSON()));
                },
                renderPhone : function(){
                    $(this.el).html(this.templatePhone(this.model.toJSON()));
                },
                events: {
                    'dragover .dropFile' : 'handleDragOver',
                    'dragleave .dropFile' : 'handleDragLeave',
                    'drop .dropFile' : 'handleDrop',
                    'change .inputFile' : 'handleFileUpload',
                    'focus .inputSKU' : 'handleFocusSKU',
                    'blur .inputSKU' : 'handleBlurSKU',
                    'blur .inputQty' : 'handleBlurQty',
                    'click .removeItem' : 'handleRemoveItem',
                    'click .removeAll' : 'handleRemoveAll',
                    'click .inputValidate' : 'handleValidateSKU',
                    'click .inputAddToCart' : 'handleAddToCart',
                },
                handleFileUpload : function(event){
                    let _this = this;
                    const files = event.target.files;
                    if (files.length === 0) return;
                    if (!files[0].type.match(/text.*/) &&
                        files[0].type !== 'application/vnd.ms-excel' &&
                        !files[0].name.endsWith('.csv')) {
                            //Error Message for allowed files
                            _this.showMessage('messagingAction-error',CCRZ.pagevars.pageLabels.TKAMB2B_QuickOrder_CSVError,'ERROR');
                        return false;
                    }
                    this.readFileAsText(files[0]);
                },
                handleDragLeave : function(event){
                    event.preventDefault();
                    const dropzone = document.getElementById('fileDropzone');
                    dropzone.classList.remove('slds-has-drag');

                    event.stopPropagation();
                },
                handleDragOver : function(event){
                    event.preventDefault();
                    const dropzone = document.getElementById('fileDropzone');
                    dropzone.classList.add('slds-has-drag');
                    event.originalEvent.dataTransfer.dropEffect = 'move';
                    event.stopPropagation();
                },
                handleDrop : function(event){
                    event.preventDefault();
                    let _this = this;
                    const dropzone = document.getElementById('fileDropzone');
                    dropzone.classList.remove('slds-has-drag');

                    if (event.originalEvent.dataTransfer.files.length === 0) return;
                    if (!event.originalEvent.dataTransfer.files[0].type.match(/text.*/) &&
                        event.originalEvent.dataTransfer.files[0].type !== 'application/vnd.ms-excel' &&
                        !event.originalEvent.dataTransfer.files[0].name.endsWith('.csv')) {
                            //Error Message for allowed files
                            _this.showMessage('messagingAction-error',CCRZ.pagevars.pageLabels.TKAMB2B_QuickOrder_CSVError,'ERROR');
                        return false;
                    }
                    this.readFileAsText(event.originalEvent.dataTransfer.files[0]);
                    event.stopPropagation();
                },
                //Add default values to the files
                addDefaultValues: function(size){
                    let productList = [];
                    for(let i = 0; i < size; i++){
                        let defaultRow = {
                            "sku" : "",
                            "quantity" : "",
                            "description" : "",
                            "basePrice" : "",
                            "itemPrice" : "",
                            "isInvalid" : false,
                            "isDuplicate": false,
                            "isOutOfStock": false
                        };
                        productList.push(defaultRow);
                    }
                    return productList;
                },
                handleBlurQty: function(event){
                    let value = event.target.value, sku = event.target.dataset.sku, _this = this, products = _this.model.get('products'), row = parseInt(event.target.dataset.rowNumber);
                    if((value != '' && parseInt(value) <= 0) || value == ''){
                        value = 1 + '';
                    }
                    products[row].quantity = value;
                    _this.model.set('products', products);
                    this.checkForAvailability();
                },
                handleBlurSKU: function(event){
                    let _this = this, sku = event.target.value, row = parseInt(event.target.dataset.rowNumber), type = event.target.dataset.type;
                    if(sku !== ''){
                        _this.updateCurrentProduct(type, sku, row);
                    }
                },
                handleFocusSKU: function(event){
                    let _this = this, products = _this.model.get('products');
                    if(event.target.dataset.rowNumber == (products.length - 1)){
                        let defaultRow = {
                            "sku" : "",
                            "quantity" : "",
                            "description" : "",
                            "basePrice" : "",
                            "itemPrice" : "",
                            "isInvalid" : false,
                            "isDuplicate": false,
                            "isOutOfStock": false
                        };
                        products.push(defaultRow);
                        _this.render();
                    }
                }, 
                handleRemoveItem: function(event){
                    let row = parseInt(event.currentTarget.dataset.rowNumber),  _this = this, products = _this.model.get('products');
                    if(products.length > 1){
                        products.splice(row, 1);
                        _this.model.set('products', products);
                    } else {
                        products.splice(row, 1);
                        products.push(_this.addDefaultValues(sizeIncrement));
                        _this.model.set('products', products);
                    }
                    this.checkForAvailability();
                },
                handleRemoveAll: function(){
                    this.model.set('products', this.addDefaultValues(defaultSize));
                    this.render();
                },
                handleValidateSKU: function(event){
                    let _this = this, copyPasteValues = $('#copyPasteValues').val(), arrayData = _this.model.get('arrayData');
                    if(arrayData.length > 0){ 
                        _this.getProductDetails(arrayData, true);
                    } else if(copyPasteValues) {
                        copyPasteValues = copyPasteValues.replace(/\t/g, ',');
                        arrayData = _this.csvToArray(copyPasteValues, ',');
                        arrayData = _this.convertArrToObject(arrayData);
                        _this.updateBulkData(arrayData);
                        _this.getProductDetails(arrayData, true);
                    }
                },
                csvToArray: function(strData, strDelimiter) {
                    const objPattern = new RegExp(("(\\" + strDelimiter + "|\\r?\\n|\\r|^)(?:\"((?:\\\\.|\"\"|[^\\\\\"])*)\"|([^\\" + strDelimiter + "\"\\r\\n]*))"), "gi");
                    let arrMatches = null, arrData = [[]];
                    while (arrMatches = objPattern.exec(strData)) {
                        if (arrMatches[1].length && arrMatches[1] !== strDelimiter) arrData.push([]);
                        arrData[arrData.length - 1].push(
                            arrMatches[2]
                                ? arrMatches[2].replace(new RegExp("[\\\\\"](.)", "g"), "$1").trim()
                                : arrMatches[3].trim()
                        );
                    }
                    return arrData;
                },
                // Read the file as text
                readFileAsText: function(file) {
                    let _this = this;
                    if (!file || file.size === 0) return null;
                    
                    let reader = new FileReader();
                    reader.readAsText(file);
                    
                    reader.onload = function(){ 
                        let arrayData = _this.csvToArray(reader.result, ',');
                        arrayData = _this.convertArrToObject(arrayData);
                        _this.model.set('arrayData', arrayData);
                        _this.updateBulkData(arrayData);
                        $('.inputValidate').click();
                    };
                        
                    reader.onerror = function() {
                        throw new ReadFileException(reader.error.message);
                    };
                },
                convertArrToObject: function(arrayData){
                    let prodList = [];
                    for(let i = 0; i < arrayData.length; i++){
                        prodList.push({
                            "sku": arrayData[i][0],
                            "quantity": arrayData[i][1]
                        });
                    }
                    return prodList;
                },
                updateBulkData: function(skuList){
                    let productList = [];
                    for(let i = 0; i < skuList.length; i++){
                        let product = {
                            "sku" : skuList[i].sku,
                            "quantity" : parseFloat(skuList[i].quantity) + '',
                            "description" : "",
                            "basePrice" : "",
                            "itemPrice" : "",
                            "isInvalid" : false,
                            "isDuplicate": false,
                            "isOutOfStock": false
                        };
                        productList.push(product);
                    }
                    this.model.set('products', productList);
                },
                handleAddToCart: function(component){
                    $('#sidebarBackdrop').removeClass('hide');
                    let _this = this;
                    let requestData = JSON.stringify({
                        "skuList" : _this.model.get('products'),
                        "cartEncId" : CCRZ.pagevars.currentCartID
                    });
                    _this.model.addProductsToCart(requestData, function(res, evt){
                        let products = _this.model.get('products');
                        if(res && res.data){
                            _this.addDefaultValues(defaultSize);
                            CCRZ.pagevars.currentCartID = res.data;
                            CCRZ.pubSub.trigger('cartChange', res.data);
                            /*setTimeout(function(){                              
                                //_this.showMessage('messagingAction-success','Products added Successfully!','SUCCESS');                              
                                $('#sidebar').addClass('active'); 
                                $('.sidebarMiniCart').removeClass('hide');
                                $('#sidebarBackdrop').removeClass('hide');
                            }, 1000); */
                            _this.model.set('products', _this.addDefaultValues(defaultSize));
                            _this.render();
                        } else {
                            // Error Handling
                            _this.showMessage('messagingAction-error',CCRZ.pagevars.pageLabels.TKAMB2B_QuickOrder_ErrorAddingProducts,'ERROR');
                        }
                        $('#sidebarBackdrop').addClass('hide');
                    });
                },
                checkForAvailability: function(){
                    let _this = this, productList = _this.model.get('products'), isValid = true, isSkuAvailable = false;
                    if(productList.length > 0){
                        for(let i = 0; i < productList.length; i++){
                            if((productList[i].isInvalid || productList[i].isDuplicate)){
                                isValid = false;
                            }
                            if(productList[i].sku != ''){
                                isSkuAvailable = true;
                            }
                        }
                    }
                    _this.model.set('disableAddToCartBtn', (isSkuAvailable?!isValid:!isSkuAvailable));
                    _this.render();
                    $('#sidebarBackdrop').addClass('hide');
                },
                showMessage: function(msgClass, message, type){
                    $('.' + msgClass).html('');
                    $('.' + msgClass).removeClass('hide');
                    CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage(type, msgClass, message));
                    setTimeout(function(){
                        $('.' + msgClass).addClass('hide');
                    }, 3000);
                },
                updateCurrentProduct: function(type, value, row){
                    let _this = this, productList = _this.model.get('products'), isDuplicate = false, defaultQuantity = '1';
                    
                    if(type == 'SKU'){
                        productList[row].sku = value;
                        productList[row].quantity = (productList[row].quantity == ''?defaultQuantity:productList[row].quantity);
                        for(let i = 0; i < productList.length; i++){
                            if(i != row && value == productList[i].sku){
                                isDuplicate = true;
                            }
                        }
                        productList[row].isDuplicate = isDuplicate;
                    } else if(type == 'QTY'){
                        productList[row].quantity = parseInt(value);
                    }
                    productList[row].description = '';
                    productList[row].itemPrice = '';
                    productList[row].isInvalid = (isDuplicate?false:productList[row].isInvalid);
                    _this.model.set('products', productList);
                    if(isDuplicate){
                        _this.checkForAvailability();
                    } else {
                        _this.getProductDetails([{"sku":productList[row].sku, "quantity": (productList[row].quantity + '')}], false);
                    }
                },
                getProductDetails: function(skuList, isBulk){
                    $('#sidebarBackdrop').removeClass('hide');
                    let _this = this, prodSkuList = [];
                    for(let i = 0; i < skuList.length; i++){
                        prodSkuList.push(skuList[i].sku);
                    }
                    let requestData = JSON.stringify({
                        "skuList" : prodSkuList
                    });
                    _this.model.getProducts(requestData, function(res, evt){
                        let products = _this.model.get('products');
                        if(res && res.data && res.data.productList && res.data.productList.length > 0){
                            for(let i = 0; i < products.length; i++){
                                let isValid = ((products[i].description == '' && products[i].sku != '')?false:true);
                                for(let j = 0; j < res.data.productList.length; j++){
                                    let prod = res.data.productList[j];
                                    if(products[i].sku == prod.SKU){
                                        isValid = true;
                                        products[i].description = prod.sfdcName;
                                        products[i].itemPrice = prod.price;
                                        products[i].basePrice = prod.basePrice;
                                    }
                                }
                                products[i].isInvalid = (isValid?false:true);
                            }
                            _this.model.set('products', products);
                            _this.model.set('arrayData', []);
                            $('#copyPasteValues').val('');
                            _this.checkForAvailability();
                        } else {
                            // Product not available
                            console.log('Get products: Error ');
                            for(let i = 0; i < products.length; i++){
                                if(products[i].description == '' && products[i].sku != ''){
                                    products[i].isInvalid = true;
                                }
                            }
                            _this.model.set('products', products);
                            _this.checkForAvailability();
                            _this.showMessage('messagingAction-error',CCRZ.pagevars.pageLabels.TKAMB2B_QuickOrder_ErrorProductDetail,'ERROR');
                        }
                    });
                }
            });
            
            //Initiate Quick Order View
            CCRZ.quickOrderCustomView = new CCRZ.views.quickOrderCustomView({
                model: new quickOrderModel()
            });
        }
    }
});