d("newCustomerView",['ccrz','util'], function(CCRZ, UTIL, newCustomerView) {
    return {
        


        extendnewCustomerView: function(){   
            CCRZ.pubSub.on("view:newCustomerView:refresh", function(newCustomerView){ 
                newCustomerView.$('.splash-promo-Desktop').prependTo('.cc_content_body');
                
                newCustomerView.delegateEvents(_.extend(newCustomerView.events,{
                    "click .submitForm" : validateData,
                    "change #sameshipping" : isShippingSameToBilling,
                    "change .billing" : handleCountryChange
                }));

                initializeDealerList();
            });

            initilizeRemoting();
            
        }
    }

    function isShippingSameToBilling(){
        if($('#sameshipping').is(':checked')){
            $('#shippingAddressPanel').addClass('tkm_hide').removeClass('tkm_show');
        }else{
            $('#shippingAddressPanel').addClass('tkm_show').removeClass('tkm_hide');
        }
    }

    function initializeDealerList(){
        /*
        const counrtyName = CCRZ.newCustomerView.model.attributes.countryList.filter(country => country.value === document.getElementsByName("billingAddress.countryCode")[0].value);
        let countryLabel = '';
        if(counrtyName && counrtyName.length > 0){
            countryLabel = counrtyName[0].label;
        }*/

        //CCRZ.subsc.RemoteAjax.getAccountCtx(countryLabel);
        CCRZ.subsc.RemoteAjax.getDealerRelatedCountries();
    }

    // Method to handle the country change 
    function handleCountryChange(event){
        /*
        const counrtyName = CCRZ.newCustomerView.model.attributes.countryList.filter(country => country.label === event.target.value);
        let countryLabel = '';
        if(counrtyName && counrtyName.length > 0){
            countryLabel = counrtyName[0].label;
        }*/
        if(event.target.value){
            CCRZ.subsc.RemoteAjax.getAccountCtx(event.target.value);
        }
    }   

    function validateData(){
        let isValidated = validateUserRegistration();
        if(isValidated){
            //$("#submit_button").attr("disabled", true);
            let reqData = NewLeadData();
            CCRZ.subsc.RemoteAjax.createLead(reqData);
        }
    }

    function initilizeRemoting(){
        CCRZ.subsc = _.extend(CCRZ.subsc||{});

        CCRZ.subsc.RemoteAjax =  _.extend(CCRZ.RemoteInvocation,{
            className : 'TKAMB2B_UserRegistrationController',
            createLead : function(reqData){
                $('body').append('<div id="overlay" class="modal-backdrop fade in"></div>');
                this.invokeCtx('createLead',
                    reqData, 
                    function(resp, evt){
                        
                        if(evt.status){
                            if(resp){
                                if(resp.success){//response was successful
                                    notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B_SiteRegistration_Thank_you_for_ecommerce_access_request'],'success',true);
                                    setTimeout(function(){ 
                                        let homePageURL= CCRZ.pageUrls.homePage + window.location.search;
                                        window.open(homePageURL,'_self');
                                    }, 5000);

                                }else{
                                    //handle response error here
                                    if(resp.data.case){

                                        let caseScenarios = resp.data.case.toLowerCase();

                                        if(caseScenarios == 'invalid dealer currency'){
                                            notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B__SiteRegistration_InvalidDealerCurrency'],'danger',false);
                                        }
                                        else if(caseScenarios == 'existing user'){
                                            notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B__SiteRegistration_ExistingUserException'],'danger',false);
                                        }
                                        else if(caseScenarios == 'invalid dealer override'){
                                            notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B_UserReg_Invalid_Dealer_Override'] + resp.data.associateddealer,'danger',false);
                                        }
                                        else if(caseScenarios == 'exception'){
                                            notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B__SiteRegistration_ExceptionInfo'],'danger',false);
                                        }

                                    }
                                }
                            }else{
                                notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B__SiteRegistration_ExceptionInfo'],'danger',false);
                            }
                        }else{
                            //handle standard RemoteAction failure here
                            notificationMessage(CCRZ.pagevars.pageLabels['TKAMB2B__SiteRegistration_ExceptionInfo'],'danger',false);
                        }
                        $('#overlay').remove();
                    },
                    {
                        buffer:false, //this call will be executed by itself
                        nmsp : false //defines that this is a call to a subscriber class
                    }
                );//end invokeCtx call
            }
        });

        CCRZ.subsc.RemoteAjax =  _.extend(CCRZ.RemoteInvocation,{
            className : 'TKAMB2B_UserRegistrationController',
            getDealerRelatedCountries : function(county){
                this.invokeCtx('getDealerRelatedCountries',
                    function(resp, evt){
                        if(evt.status){
                            if(resp && resp.success){                 
                                let selectBox = document.getElementById("dealer");
                                
                                //selectBox.innerHTML = "";
                                if(resp.data.dealers){

                                    for (let dealer of resp.data.dealers) {
                                        let opt = document.createElement("option");
                                        opt.value = dealer.Id;
                                        opt.text = dealer.Name;
                                        selectBox.add(opt, null);
                                    }
                                }

                                let countrySelection = document.getElementById("country-list");
                                //countrySelection.innerHTML = "";
                                
                                for (let country of resp.data.countryList) {
                                    let opt = document.createElement("option");

                                    country = htmlDecode(country);

                                    opt.value = country;
                                    opt.text = country;
                                    countrySelection.add(opt, null);
                                }

                            }else{
                                //handle response error here
                            }
                        }else{
                            //handle standard RemoteAction failure here
                        }
                    },
                    {
                        buffer:false, //this call will be executed by itself
                        nmsp : false //defines that this is a call to a subscriber class
                    }
                );//end invokeCtx call
            }
        });

        CCRZ.subsc.RemoteAjax =  _.extend(CCRZ.RemoteInvocation,{
            className : 'TKAMB2B_UserRegistrationController',
            getAccountCtx : function(county){
                this.invokeCtx('getAccountCtx',
                    county, 
                    function(resp, evt){
                        if(evt.status){
                            if(resp && resp.success){      
                                let moreoptionslabel = CCRZ.pagevars.pageLabels['TKAMB2B_SeeMoreOptionText'];
                                let dealerDisplayPlaceHolder = "--"+CCRZ.pagevars.pageLabels["TKAMB2B_SiteRegistration_Dealer"]+"--";
                                let selectBox = document.getElementById("dealer");
                                selectBox.innerHTML = "";
                                selectBox.value = "";

                                let dealerDisplay = document.getElementById("dealer-display");
                                dealerDisplay.setAttribute("data-text",dealerDisplayPlaceHolder);
                                dealerDisplay.innerText = "";

                                let otherCountry = false;
                                let onlyonce = false;

                                for (let dealer of resp.data.dealers) {

                                    dealer.Name = htmlDecode(dealer.Name);
                                    dealer.BillingCountry = htmlDecode(dealer.BillingCountry);

                                    if(!onlyonce && dealerDisplay){
                                        selectBox.value = dealer.Id;
                                        dealerDisplay.innerText = dealer.Name + ' ('+ dealer.BillingCountry +')';
                                        dealerDisplay.removeAttribute("data-text");
                                        onlyonce = true;
                                    }

                                    let opt = document.createElement("a");

                                    opt.id = dealer.Id;
                                    opt.text = dealer.Name + ' ('+ dealer.BillingCountry +')';

                                    opt.setAttribute("onclick","selectDealer('"+dealer.Id+"')");

                                    if(county != dealer.BillingCountry){
                                        otherCountry = true;
                                        opt.classList.add("othercountrydealer");
                                        opt.classList.add("expandable");
                                    }

                                    selectBox.appendChild(opt);
                                }

                                if(otherCountry){
                                    let opt = document.createElement("a");

                                    opt.id = "seemoreopt";
                                    opt.text = moreoptionslabel;

                                    opt.setAttribute("onclick","showOtherDealers()");

                                    selectBox.appendChild(opt);
                                }

                                /*
                                while (selectBox.options.length > 0) {
                                    selectBox.remove(0);
                                }
                                
                                for (let dealer of resp.data.dealers) {
                                    let opt = document.createElement("option");
                                    opt.value = dealer.Id;
                                    opt.text = dealer.Contact.Account.Name ;
                                    selectBox.add(opt, null);
                                }*/

                            }else{
                                //handle response error here
                            }
                        }else{
                            //handle standard RemoteAction failure here
                        }
                    },
                    {
                        buffer:false, //this call will be executed by itself
                        nmsp : false //defines that this is a call to a subscriber class
                    }
                );//end invokeCtx call
            }
        });

    }

    function htmlDecode(input) {
        var doc = new DOMParser().parseFromString(input, "text/html");
        return doc.documentElement.textContent;
    }

    function NewLeadData(){
        let userData = {};
        let isBillingAddSame = $('#sameshipping').is(':checked');
        userData['firstname'] = $.trim($('#firstname').val());
        userData['lastname'] = $.trim($('#lastname').val());
        userData['phonenumber'] = $.trim($('#phonenumber').val());
        userData['email'] = $.trim($('#email').val());
        userData['confirmemail'] = $.trim($('#confirmemail').val());

        userData['dealer'] = $.trim($("#dealer").val());//$.trim($("#dealer option:selected").val());
        userData['companyname'] = $.trim($('#companyname').val());
        userData['companyreg'] = $.trim($('#companyreg').val());
        //userData['dealercode'] = $.trim($('#dealercode').val());
        userData['vat'] = $.trim($('#vat').val());

        userData['billingaddress1'] = $.trim($('#billingaddress1').val());
        userData['billingaddress2'] = $.trim($('#billingaddress2').val());
        userData['billingcity'] = $.trim($('#billingcity').val());
        userData['billingpostalcode'] = $.trim($('#billingpostalcode').val());
        userData['billingstate'] = $.trim($('#billingstate').val());
        userData['billingcountry'] = $.trim($(".countryListing option:selected").text());

        userData['shippingaddress1'] = isBillingAddSame ? userData['billingaddress1']:$.trim($('#shippingaddress1').val());
        userData['shippingaddress2'] = isBillingAddSame ? userData['billingaddress2']:$.trim($('#shippingaddress2').val());
        userData['shippingcity'] = isBillingAddSame ? userData['billingcity']:$.trim($('#shippingcity').val());
        userData['shippingpostalcode'] = isBillingAddSame ? userData['billingpostalcode']:$.trim($('#shippingpostalcode').val());
        userData['shippingstate'] = isBillingAddSame ? userData['billingstate']:$.trim($('#shippingstate').val());
        userData['shippingcountry'] = $.trim($(".countryListing option:selected").text());

        return JSON.stringify(userData);

    }

    function validateUserRegistration(){
        let isValidated = true;
        let errorMsg = CCRZ.pagevars.pageLabels['TKAMB2B_SiteRegistration_this_is_required_field'];
        let errorMsgTooLong = CCRZ.pagevars.pageLabels['TKAMB2B_SiteRegistration_this_filed_is_too_long'];
        console.log('errorMsgTooLong - ' + errorMsgTooLong);
        
        if(UTIL.isValidField('firstname')){
            $('#firstname_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#firstname_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#firstname_error').text(errorMsg);
            isValidated = false;
        }
        if(UTIL.isValidField('lastname')){
            
            $('#lastname_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#lastname_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#lastname_error').text(errorMsg);
            isValidated = false;
        }

        if(UTIL.isValidField('phonenumber')){
            $('#phonenumber_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#phonenumber_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#phonenumber_error').text(errorMsg);
            isValidated = false;
        }

        if(UTIL.isValidField('email')){
            if(UTIL.validateEmail($.trim($('#email').val()))){
                $('#email_error').removeClass('tkm_show').addClass('tkm_hide');
            }else{
                $('#email_error').addClass('tkm_show').removeClass('tkm_hide');
                $('#email_error').text(CCRZ.pagevars.pageLabels['TKAMB2B_SiteRegistration_Invalid_Email']);
                isValidated = false;
            }
        }else{
            $('#email_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#email_error').text(errorMsg);
            isValidated = false;
        }

        if(UTIL.isValidField('confirmemail')){
            if(UTIL.validateEmail($.trim($('#confirmemail').val()))){
                $('#confirmemail_error').removeClass('tkm_show').addClass('tkm_hide');
            }else{
                $('#confirmemail_error').addClass('tkm_show').removeClass('tkm_hide');
                $('#confirmemail_error').text(CCRZ.pagevars.pageLabels['TKAMB2B_SiteRegistration_Invalid_Email']);
                isValidated = false;
            }
        }else{
            $('#confirmemail_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#confirmemail_error').text(errorMsg);
            isValidated = false;
        }

        if($('#email').val() && $('#confirmemail').val()){

            if($.trim($('#email').val()) === $.trim($('#confirmemail').val())){

                $('#email_error').removeClass('tkm_show').addClass('tkm_hide');
                $('#confirmemail_error').removeClass('tkm_show').addClass('tkm_hide');
            }else{
                $('#email_error').addClass('tkm_show').removeClass('tkm_hide');
                $('#confirmemail_error').addClass('tkm_show').removeClass('tkm_hide');

                let diffEmail = CCRZ.pagevars.pageLabels['TKAMB2B_SiteRegistration_Invalid_Confirmed_Email'];

                $('#email_error').text(diffEmail);
                $('#confirmemail_error').text(diffEmail);
                isValidated = false;
            }
        }


        if(UTIL.isValidField('companyname')){
            $('#companyname_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#companyname_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#companyname_error').text(errorMsg);
            isValidated = false;
        }

        if(UTIL.isValidField('companyreg')){
            $('#companyreg_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#companyreg_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#companyreg_error').text(errorMsg);
            isValidated = false;
        }

        if(UTIL.isValidField('dealer')){
            $('#dealer_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#dealer_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#dealer_error').text(errorMsg);
            isValidated = false;
        }

        /*
        if(UTIL.isValidField('dealercode')){
            $('#dealercode_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#dealercode_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#dealercode_error').text(errorMsg);
            isValidated = false;
        }*/

        if(UTIL.isValidField('vat')){
            $('#vat_error').removeClass('tkm_show').addClass('tkm_hide');
        }else{
            $('#vat_error').addClass('tkm_show').removeClass('tkm_hide');
            $('#vat_error').text(errorMsg);
            isValidated = false;
        }

        if(UTIL.isValidField('billingaddress1')){
            removeValidationError('billingaddress1_error');
        }else{
            isValidated = addValidationError('billingaddress1_error',errorMsg);
        }

        if($('#billingaddress1').val().length < 128){
            removeValidationError('billingaddress1_error');
        }else{
            isValidated = addValidationError('billingaddress1_error', errorMsgTooLong);
        }

        if($('#billingaddress2').val().length < 128){
            removeValidationError('billingaddress2_error');
        }else{
            isValidated = addValidationError('billingaddress2_error', errorMsgTooLong);
        }

        if(UTIL.isValidField('billingcity')){
            removeValidationError('billingcity_error');
        }else{
            isValidated = addValidationError('billingcity_error',errorMsg);
        }
        /*
        if(UTIL.isValidField('billingstate')){
            removeValidationError('billingstate_error');
        }else{
            isValidated = addValidationError('billingstate_error',errorMsg);
        }
        */
        if(UTIL.isValidField('billingpostalcode')){
            removeValidationError('billingpostalcode_error');
        }else{
            isValidated = addValidationError('billingpostalcode_error',errorMsg);
        }


        if(UTIL.isValidField('shippingaddress1')){
            removeValidationError('shippingaddress1_error');
        }else{
            isValidated = addValidationError('shippingaddress1_error',errorMsg);
        }

        if($('#shippingaddress1').val().length < 128){
            removeValidationError('shippingaddress1_error');
        }else{
            isValidated = addValidationError('shippingaddress1_error', errorMsgTooLong);
        }
        if($('#shippingaddress2').val().length < 128){
            removeValidationError('shippingaddress2_error');
        }else{
            isValidated = addValidationError('shippingaddress2_error', errorMsgTooLong);
        }

        if(UTIL.isValidField('shippingcity')){
            removeValidationError('shippingcity_error');
        }else{
            isValidated = addValidationError('shippingcity_error',errorMsg);
        }
        /*
        if(UTIL.isValidField('shippingstate')){
            removeValidationError('shippingstate_error');
        }else{
            isValidated = addValidationError('shippingstate_error',errorMsg);
        }
        */

        if(UTIL.isValidField('shippingpostalcode')){
            removeValidationError('shippingpostalcode_error');
        }else{
            isValidated = addValidationError('shippingpostalcode_error',errorMsg);
        }


        if(!$("#termscheck").is(':checked')){ 
            $('#termscheck_error').removeClass('tkm_hide').addClass('tkm_show');
            isValidated = false;
        }else{ 
            $('#termscheck_error').removeClass('tkm_show').addClass('tkm_hide');
        }
        
        return isValidated;
    }

    function addValidationError(elementId,errorMsg){
        $('#'+elementId).addClass('tkm_show').removeClass('tkm_hide');
        $('#'+elementId).text(errorMsg);
        return false;
    }

    function removeValidationError(elementId){
        $('#'+elementId).removeClass('tkm_show').addClass('tkm_hide');
    }

    function notificationMessage(msg,type,hidepanel){

        $(window).scrollTop(0);

        let msgHtml = '<div class="alert alert-'+type+'" role="alert">';
        msgHtml+= msg;       
        msgHtml+=' </div>'
        $('#notification_msg_panel').html(msgHtml);
        $('#notification_msg_panel').show();

        if(hidepanel){
            setTimeout(function(){ 
                $('#notification_msg_panel').hide(); 
                $('#notification_msg_panel').html();
            }, 5000);
        }
    }

});